SET autocommit=0;
DROP FUNCTION IF EXISTS touchProduct;
DROP PROCEDURE IF EXISTS touchValue;
delimiter //
CREATE FUNCTION touchProduct (_BrandName VARCHAR(255),_ProductHandler VARCHAR(255), _Description TEXT) RETURNS INTEGER(11)
			BEGIN
				DECLARE _ParameterId INTEGER(11);
				DECLARE _BrandId INTEGER(11);
				DECLARE _ProductId INTEGER(11);
				DECLARE _ProfileId INTEGER(11);
				DECLARE _UriId INTEGER(11);

				SELECT BrandId INTO _BrandId FROM pbrand WHERE BrandName=_BrandName;

				IF _BrandId IS NULL THEN
					RETURN NULL;
				END IF;

				SELECT ProductId INTO _ProductId FROM pproduct P WHERE P.ProductHandler=_ProductHandler;

				IF _ProductId IS NULL THEN
					INSERT INTO profile (ProfileUriId, ActivationStatus, Login) VALUES (NULL, 'A', _ProductHandler);
					SET _ProfileId = LAST_INSERT_ID();
					INSERT INTO turi (SchemaId, ShareLevel, ProfileId, Uri) VALUES (1, 'N', _ProfileId , CONCAT('profile://',_ProductHandler,'@site.com'));
					SET _UriId = LAST_INSERT_ID();


					INSERT INTO pproduct SET ProductId=_ProfileId,BrandId=_BrandId,ProductHandler=_ProductHandler;
					SET _ProductId = LAST_INSERT_ID();
				END IF;

				RETURN _ProductId;
			END//
CREATE PROCEDURE touchValue (_ProductId INTEGER(11),_ParameterName VARCHAR(64), _Value TEXT)
			BEGIN
				DECLARE _ParameterId INTEGER(11);
				DECLARE _LanguageId INTEGER(11);
				DECLARE _DistinctId INTEGER(11);

				IF _ProductId IS NOT NULL THEN

					SELECT ParameterId INTO _ParameterId FROM dparameter WHERE ParameterName=_ParameterName;

					IF _ParameterId IS NULL THEN
						SELECT ParameterId INTO _ParameterId FROM ddictionary WHERE AltName=_ParameterName;
					END IF;



					IF _ParameterId IS NOT NULL THEN

						SELECT LanguageId,DistinctId INTO _LanguageId,_DistinctId FROM ddistinct WHERE Value = _Value AND ParameterId=_ParameterId;

						IF _DistinctId IS NULL THEN
							SET _LanguageId = 2;
							INSERT IGNORE INTO ddistinct (ParameterId,LanguageId,Value) VALUES(_ParameterId,_LanguageId,_Value);
						END IF;

						INSERT IGNORE INTO dvalue (ProductId,ParameterId,LanguageId,Value) VALUES (_ProductId,_ParameterId,_LanguageId,_Value);
					END IF;

				END IF;

			END//
delimiter ;
START TRANSACTION;
SET @ProductId = touchProduct ('Acer','LX.PW502.004', '');
call touchValue(@ProductId,'Decsription','Genuine Windows® 7 Home Premium -  64-bit version - Intel® Core™ i5-520UM processor 1.06GHz with Turbo Boost Technology up to 1.');
call touchValue(@ProductId,'Image','http://static.acer.com/up/Resource/Acer/Notebooks/Aspire Series/Images/20101209/Aspire_350x250.jpg');
call touchValue(@ProductId,'Model','AS1430-4857');
call touchValue(@ProductId,'Handler','LX.PW502.004');
call touchValue(@ProductId,'Part Number','LX.PW502.004');
call touchValue(@ProductId,'Price','599.99 USD');
call touchValue(@ProductId,'Series','Aspire');
call touchValue(@ProductId,'Operating System','Genuine Windows® 7 Home Premium');
call touchValue(@ProductId,'Processor Manufacturer','Intel');
call touchValue(@ProductId,'Processor Type','Core i5');
call touchValue(@ProductId,'Processor Model','i5-520M');
call touchValue(@ProductId,'Processor Speed','2.40 GHz');
call touchValue(@ProductId,'Processor Core','Dual-core');
call touchValue(@ProductId,'Cache','3 MB');
call touchValue(@ProductId,'64-bit Processing','Yes');
call touchValue(@ProductId,'Hyper-Threading','Yes');
call touchValue(@ProductId,'Chipset Manufacturer','Intel');
call touchValue(@ProductId,'Chipset Model','HM55 Express');
call touchValue(@ProductId,'Standard Memory','4 GB');
call touchValue(@ProductId,'Maximum Memory','4 GB');
call touchValue(@ProductId,'Memory Technology','DDR3 SDRAM');
call touchValue(@ProductId,'Memory Standard','DDR3-1066/PC3-8500');
call touchValue(@ProductId,'Number of Total Memory Slots','2');
call touchValue(@ProductId,'Memory Card Reader','Yes');
call touchValue(@ProductId,'Memory Card Support','Memory StickMemory Stick PROSecure Digital (SD) CardxD-Picture CardMultiMediaCard (MMC)');
call touchValue(@ProductId,'Hard Drive Capacity','320 GB');
call touchValue(@ProductId,'Optical Drive Type','Not Included');
call touchValue(@ProductId,'Optical Media Support','Not Applicable');
call touchValue(@ProductId,'Screen Size','11.6\"');
call touchValue(@ProductId,'Display Screen Type','Active Matrix TFT Color LCD');
call touchValue(@ProductId,'Display Screen Technology','CineCrystal');
call touchValue(@ProductId,'Aspect Ratio','16:9');
call touchValue(@ProductId,'Screen Mode','WXGA');
call touchValue(@ProductId,'Display Resolution','1366 x 768');
call touchValue(@ProductId,'Backlight Technology','LED');
call touchValue(@ProductId,'Color Support','16.7 Million Colors');
call touchValue(@ProductId,'HDCP Support','Yes');
call touchValue(@ProductId,'Wi-Fi','Yes');
call touchValue(@ProductId,'Wi-Fi Standard','IEEE 802.11b/g/n');
call touchValue(@ProductId,'Ethernet Technology','Gigabit Ethernet');
call touchValue(@ProductId,'Webcam','Yes');
call touchValue(@ProductId,'Microphone','Yes');
call touchValue(@ProductId,'HDMI','Yes');
call touchValue(@ProductId,'USB Standard','USB 2.0');
call touchValue(@ProductId,'Number of USB Ports','3');
call touchValue(@ProductId,'VGA','Yes');
call touchValue(@ProductId,'Network (RJ-45)','Yes');
call touchValue(@ProductId,'Operating System Architecture','64-bit');
call touchValue(@ProductId,'Keyboard','Yes');
call touchValue(@ProductId,'Pointing Device Type','TouchPad');
call touchValue(@ProductId,'Number of Cells','6-cell');
call touchValue(@ProductId,'Battery Chemistry','Lithium Ion (Li-Ion)');
call touchValue(@ProductId,'Battery Capacity','4400 mAh');
call touchValue(@ProductId,'Maximum Battery Run Time','6 Hour');
call touchValue(@ProductId,'Maximum Power Supply Wattage','40 W');
call touchValue(@ProductId,'Color','Black');
call touchValue(@ProductId,'Height','1.10\"');
call touchValue(@ProductId,'Width','11.20\"');
call touchValue(@ProductId,'Depth','8\"');
call touchValue(@ProductId,'Weight (Approximate)','3.09 lb');
call touchValue(@ProductId,'Package Contents','Aspire AS1430-52U4G32nki NotebookLithium Ion BatteryAC Adapter');
SET @ProductId = touchProduct ('Acer','LX.SBB02.073', '');
call touchValue(@ProductId,'Decsription','Genuine Windows® 7 Home Premium -  64-bit version - AMD Athlon™ II Neo Dual-Core Mobile Processor K325 (1.3GHz - 2MB L2 cache - ');
call touchValue(@ProductId,'Image','http://static.acer.com/up/Resource/Acer/Notebooks/Aspire Series/Images/20101209/Aspire_350x250.jpg');
call touchValue(@ProductId,'Model','AS1551-4755');
call touchValue(@ProductId,'Handler','LX.SBB02.073');
call touchValue(@ProductId,'Part Number','LX.SBB02.073');
call touchValue(@ProductId,'Price','499.99 USD');
call touchValue(@ProductId,'Series','Aspire');
call touchValue(@ProductId,'Operating System','Genuine Windows® 7 Home Premium');
call touchValue(@ProductId,'Processor Manufacturer','AMD');
call touchValue(@ProductId,'Processor Type','Athlon II Neo');
call touchValue(@ProductId,'Processor Model','K325');
call touchValue(@ProductId,'Processor Speed','1.30 GHz');
call touchValue(@ProductId,'Processor Core','Dual-core');
call touchValue(@ProductId,'Cache','2 MB');
call touchValue(@ProductId,'64-bit Processing','Yes');
call touchValue(@ProductId,'Chipset Manufacturer','AMD');
call touchValue(@ProductId,'Chipset Model','M880G');
call touchValue(@ProductId,'Standard Memory','3 GB');
call touchValue(@ProductId,'Maximum Memory','4 GB');
call touchValue(@ProductId,'Memory Technology','DDR3 SDRAM');
call touchValue(@ProductId,'Number of Total Memory Slots','2');
call touchValue(@ProductId,'Memory Card Reader','Yes');
call touchValue(@ProductId,'Memory Card Support','Secure Digital (SD) CardMultiMediaCard (MMC)Memory Stick PROMemory StickxD-Picture Card');
call touchValue(@ProductId,'Hard Drive Capacity','250 GB');
call touchValue(@ProductId,'Optical Drive Type','Not Included');
call touchValue(@ProductId,'Optical Media Support','Not Applicable');
call touchValue(@ProductId,'Screen Size','11.6\"');
call touchValue(@ProductId,'Display Screen Type','Active Matrix TFT Color LCD');
call touchValue(@ProductId,'Display Screen Technology','CineCrystal');
call touchValue(@ProductId,'Aspect Ratio','16:9');
call touchValue(@ProductId,'Screen Mode','WXGA');
call touchValue(@ProductId,'Display Resolution','1366 x 768');
call touchValue(@ProductId,'Backlight Technology','LED');
call touchValue(@ProductId,'Color Support','16.7 Million Colors');
call touchValue(@ProductId,'HDCP Support','Yes');
call touchValue(@ProductId,'Wi-Fi','Yes');
call touchValue(@ProductId,'Wi-Fi Standard','IEEE 802.11b/g/n');
call touchValue(@ProductId,'Ethernet Technology','Gigabit Ethernet');
call touchValue(@ProductId,'Webcam','Yes');
call touchValue(@ProductId,'Microphone','Yes');
call touchValue(@ProductId,'Operating System Architecture','64-bit');
call touchValue(@ProductId,'Keyboard','Yes');
call touchValue(@ProductId,'Pointing Device Type','TouchPad');
call touchValue(@ProductId,'Number of Cells','6-cell');
call touchValue(@ProductId,'Battery Chemistry','Lithium Ion (Li-Ion)');
call touchValue(@ProductId,'Battery Capacity','4400 mAh');
call touchValue(@ProductId,'Maximum Battery Run Time','5 Hour');
call touchValue(@ProductId,'Maximum Power Supply Wattage','65 W');
call touchValue(@ProductId,'Color','Black');
call touchValue(@ProductId,'Height','1.10\"');
call touchValue(@ProductId,'Width','11.20\"');
call touchValue(@ProductId,'Depth','8\"');
call touchValue(@ProductId,'Weight (Approximate)','3.10 lb');
call touchValue(@ProductId,'Package Contents','Aspire AS1551-4755 Notebook PC Lithium Ion Battery AC Adapter');
call touchValue(@ProductId,'Bus Speed','2000 MHz');
call touchValue(@ProductId,'Hard Drive Interface','Serial ATA');
call touchValue(@ProductId,'Hard Drive RPM','5400');
call touchValue(@ProductId,'Solid State Drive Capacity','Not Included');
call touchValue(@ProductId,'Solid State Drive Interface','Not Applicable');
call touchValue(@ProductId,'Graphics Controller Manufacturer','ATI');
call touchValue(@ProductId,'Graphics Controller Model','Mobility Radeon HD 4225');
call touchValue(@ProductId,'Graphics Memory Capacity','384 MB');
call touchValue(@ProductId,'Wi-Fi Manufacturer','Acer');
call touchValue(@ProductId,'Wi-Fi Model','InviLink Nplify');
call touchValue(@ProductId,'Software Included','Acer Assist Acer ePower Management Acer eRecovery Management Acer Identity Card Acer Registration Acer Updater Acer Video Confer');
SET @ProductId = touchProduct ('Acer','LX.PTV02.315', '');
call touchValue(@ProductId,'Decsription','Genuine Windows® 7 Home Premium -  64-bit version - Intel® Core™ i3-380UM Processor (1.33GHz - 3MB L3 cache) - 3GB DDR3 SDRAM - ');
call touchValue(@ProductId,'Image','http://static.acer.com/up/Resource/Acer/Notebooks/Aspire Series/Images/20101209/Aspire_350x250.jpg');
call touchValue(@ProductId,'Model','AS1830T-6478');
call touchValue(@ProductId,'Handler','LX.PTV02.315');
call touchValue(@ProductId,'Part Number','LX.PTV02.315');
